#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// FrankenshaderMod01.fsh    by    darrinm  
//https://www.shadertoy.com/view/M3SfRm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// I used Claude Sonnet 3.5 to combine mrange's https://www.shadertoy.com/view/ctBSRR with Flexi's https://www.shadertoy.com/view/4df3zH.
// Full experience on Hatch: https://darrin.hatch.one/frankenshader

/* Uniforms for https://hatch.one

uniform float speed; // default: 0.3, min: 0.0, max: 2.0, step: 0.01, title: "animation speed"
uniform float colorIntensity; // default: 8.0, min: 1.0, max: 20.0, step: 0.1, title: "color intensity"
uniform float lensRadius; // default: 0.166, min: 0.01, max: 0.5, step: 0.01, title: "lens radius"
uniform float lensRefractivity; // default: 1.575, min: 1.0, max: 2.5, step: 0.01, title: "lens refractivity"
*/

#define speed 0.3
#define colorIntensity 8.0
#define lensRadius 0.3
#define lensRefractivity 2.5


#define TIME        iTime
#define RESOLUTION  iResolution
#define pi 3.141592653589793238462643383279

float df(vec2 p) {
  const float m = 0.25;
  float l = length(p);
  l = mod(l+(0.5*m), m)-(0.5*m);
  return abs(l)-(m*0.25);
}

// License: MIT, author: Inigo Quilez, found: https://www.iquilezles.org/www/articles/smin/smin.htm
float pmin(float a, float b, float k) {
  float h = clamp(0.5+0.5*(b-a)/k, 0.0, 1.0);
  return mix(b, a, h) - k*h*(1.0-h);
}

// License: CC0, author: Mårten Rånge, found: https://github.com/mrange/glsl-snippets
float pmax(float a, float b, float k) {
  return -pmin(-a, -b, k);
}

vec3 effect(vec2 p, vec2 pp) {
  float aa = 2.0/RESOLUTION.y;
  float tm = TIME*speed;
  vec2 p0 = p+sin(vec2(1.0, sqrt(0.5))*(tm+100.0));
  vec2 p1 = p+sin(1.2*vec2(1.0, sqrt(0.5))*(tm+200.0));
  float sm = 0.0666*length(p);
  float d0 = df(p0);
  float d1 = df(p1);
  float d = d0;
  d = pmax(d, d1, sm);
  float dd = -d0;
  dd = pmax(dd, -d1, sm);
  d =  min(d, dd);
  const float co = 0.5;
  vec3 bcol0 = (1.0+sin(vec3(0.0, 1.0, 2.0) + co*length(p0)+1.0-TIME))/(colorIntensity*dot(p0, p0)+0.0001);
  vec3 bcol1 = (1.0+sin(vec3(0.0, 1.0, 2.0) + co*length(p1)+3.0+TIME))/(colorIntensity*dot(p1, p1)+0.0001);
  vec3 bcol = (bcol0+bcol1);
  vec3 col = vec3(0.0);
  col += 0.005*bcol/(max(dd+0.005, 0.0)+0.0001);
  col = mix(col, bcol, smoothstep(aa, -aa, d));
  col -= 0.25*vec3(0.0, 1.0, 2.0).zyx*length(pp);
  col *= smoothstep(1.5, 0.5, length(pp));
  col = clamp(col, 0.0, 1.0);
  col = sqrt(col);
  return col;
}

float atan2(float y, float x){
    if(x>0.) return atan(y/x);
    if(y>=0. && x<0.) return atan(y/x) + pi; 
    if(y<0. && x<0.) return atan(y/x) - pi; 
    if(y>0. && x==0.) return pi/2.;
    if(y<0. && x==0.) return -pi/2.;
    if(y==0. && x==0.) return pi/2.; // undefined usually
    return pi/2.;
}

vec2 uv_polar(vec2 uv, vec2 center){
    vec2 c = uv - center;
    float rad = length(c);
    float ang = atan2(c.x,c.y);
    return vec2(ang, rad);
}

vec2 uv_lens_half_sphere(vec2 uv, vec2 position, float radius, float refractivity){
    vec2 polar = uv_polar(uv, position);
    float cone = clamp(1.-polar.y/radius, 0., 1.);
    float halfsphere = sqrt(1.-pow(cone-1.,2.));
    float w = atan2(1.-cone, halfsphere);
    float refrac_w = w-asin(sin(w)/refractivity);
    float refrac_d = 1.-cone - sin(refrac_w)*halfsphere/cos(refrac_w);
    vec2 refrac_uv = position + vec2(sin(polar.x),cos(polar.x))*refrac_d*radius;
    return mix(uv, refrac_uv, float(length(uv-position)<radius));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord.xy / iResolution.xy;
    vec2 aspect = vec2(1., iResolution.y/iResolution.x);
    vec2 uv_correct = 0.5 + (uv - 0.5) * aspect;


    vec2 mouse_correct = 0.5 + (iMouse.xy / iResolution.xy - 0.5) * aspect;
    if (iMouse.x == 0. && iMouse.y == 0.) {
        mouse_correct = vec2(0.5, 0.5);
    }
    vec2 pos = mouse_correct;

    vec2 uv_lens_distorted = uv_lens_half_sphere(uv_correct, pos, lensRadius, lensRefractivity);
    uv_lens_distorted = 0.5 + (uv_lens_distorted - 0.5) / aspect;

    vec2 p = -1. + 2. * uv_lens_distorted;
    vec2 pp = p;
    p.x *= RESOLUTION.x/RESOLUTION.y;
    
    vec3 col = effect(p, pp);
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

